/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OvenBlock
extends Block {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public OvenBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void setLit(BlockState state, Player player, Level level, BlockPos pos, ItemStack stack, InteractionHand handIn) {
        level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.4f + 0.8f);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 11);
        stack.m_41622_(1, (LivingEntity)player, action -> action.m_21190_(handIn));
    }

    public void extinguish(BlockState state, Level level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = pos.m_123342_();
        double d2 = (double)pos.m_123343_() + 0.5;
        level.m_7785_(d0, d1, d2, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 1.0f, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue()) {
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = (double)pos.m_123342_() + 0.3;
            double d2 = (double)pos.m_123343_() + 0.5;
            if (rand.m_188500_() < 0.1) {
                level.m_7785_(d0, d1, d2, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)stateIn.m_61143_((Property)FACING);
            Direction.Axis direction$axis = direction.m_122434_();
            double d3 = 0.52;
            double d4 = rand.m_188500_() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : d4;
            double d6 = rand.m_188500_() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : d4;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true));
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entityIn) {
        boolean isLit = (Boolean)level.m_8055_(pos).m_61143_((Property)LIT);
        if (isLit && !entityIn.m_5825_() && entityIn instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entityIn))) {
            entityIn.m_6469_(DamageSource.f_19309_, 1.0f);
        }
        super.m_141947_(level, pos, state, entityIn);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            if (itemstack.m_41720_() instanceof BucketItem && ((BucketItem)itemstack.m_41720_()).getFluid().m_205067_(FluidTags.f_13131_)) {
                this.extinguish(state, level, pos);
                player.m_21008_(handIn, new ItemStack((ItemLike)Items.f_42446_));
                return InteractionResult.SUCCESS;
            }
        } else if (itemstack.m_41720_() instanceof FlintAndSteelItem) {
            this.setLit(state, player, level, pos, itemstack, handIn);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LIT});
    }
}

